﻿/*
	VERSION:		1.3
	
	1.3:		added optional "collision_array" parameter allowing these functions to be stored seperately from the collision data
	
	WHAT THIS IS:
		This adds collision functions to a 2D collision array.
		
	FUNCTIONS:
		twoPointCollide()			Returns the collision in the specified direction, using box collision.		(1   else   top-left ID)
		getPixelCollision()			Converts pixel coordinates to tile coordinates and returns the collision of the tile they fall on.
*/
function addCollisionMethods( _this )
{
	_this.twoPointCollide = function( side, sprite_mc, velocity_obj, xOffset, yOffset )
	{
		var collision_array = _this.collision_array || _this;
		// side				The direction to look.
		// sprite_mc		The source of the _x and _y coordinates.
		// velocity_obj	The source of the xVel and yVel variables.  (This can also be the sprite)
		// xOffset			Specifies the center to something other than the top-left corner.
		// yOffset			Specifies the center to something other than the top-left corner.
		// resolve optional parameters
		var xOffset = (xOffset) ? xOffset : 0;
		var yOffset = (yOffset) ? yOffset : 0;
		// define the center point
		var pointA = new flash.geom.Point(sprite_mc._x + velocity_obj.xVel, sprite_mc._y + velocity_obj.yVel);
		var pointB = pointA.clone();
		buffer = 4;		// Shrinks the collision box
		
		switch(side)
		{
			case "up":
				pointA.x -= (sprite_mc.width-buffer);
				pointA.y -= sprite_mc.height;
				pointB.x += (sprite_mc.width-buffer);
				pointB.y -= sprite_mc.height;
			break;
			case "down":
				pointA.x -= (sprite_mc.width-buffer);
				pointA.y += sprite_mc.height;
				pointB.x += (sprite_mc.width-buffer);
				pointB.y += sprite_mc.height;
			break;
			case "left":
				pointA.x -= sprite_mc.width;
				pointA.y -= (sprite_mc.height-buffer);
				pointB.x -= sprite_mc.width;
				pointB.y += (sprite_mc.height-buffer);
			break;
			case "right":
				pointA.x += sprite_mc.width;
				pointA.y -= (sprite_mc.height-buffer);
				pointB.x += sprite_mc.width;
				pointB.y += (sprite_mc.height-buffer);
			break;
		}// switch(side)
		// apply offset
		pointA.x += xOffset;
		pointA.y += yOffset;
		pointB.x += xOffset;
		pointB.y += yOffset;
		// convert pixels to tiles
		pointA.x = Math.floor(pointA.x / 16);
		pointA.y = Math.floor(pointA.y / 16);
		pointB.x = Math.floor(pointB.x / 16);
		pointB.y = Math.floor(pointB.y / 16);
		// read the collision ID
		var collisionA = collision_array[pointA.x][pointA.y];
		var collisionB = collision_array[pointB.x][pointB.y];
		var output = 0;
		if (collisionA > 0  ||  collisionB > 0)
		{
			if (collisionA == 1  ||  collisionB == 1)
			{
				output = 1;
			}else{
				output = collisionA;
			}// if (collisionA == collisionB)
		}// if (collisionA || collisionB)
		return output;
	}// twoPointCollide()
	
	
	
	_this.getPixelCollision = function(x, y)
	{
		var collision_array = _this.collision_array || _this;
		var x = Math.floor( x / 16 );
		var y = Math.floor( y / 16 );
		return collision_array[x][y];
	}// getPixelCollision()
	
	
	
	// NOTE:		This function can be used with aStar
	_this.getTileCollision(x, y)
	{
		var collision_array = _this.collision_array || _this;
		return collision_array[x][y];
	}// getTileCollision()
	
}// addCollisionMethods()